# -*- coding: UTF-8 -*-
# Copyright © 2010-2013 Piotr Ożarowski <piotr@debian.org>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import re
import optparse
from copy import copy
from dhpython.version import VersionRange


def parse_version_range(option, opt, value):
    try:
        return VersionRange(value)
    except ValueError:
        raise optparse.OptionValueError("version range is invalid: %s" % value)


def compile_regexpr(option, opt, value):
    try:
        pattern = re.compile(value)
    except Exception:
        raise optparse.OptionValueError('regular expression is not valid')
    return pattern


class Option(optparse.Option):
    TYPES = optparse.Option.TYPES + ('version_range', 'regexpr')
    TYPE_CHECKER = copy(optparse.Option.TYPE_CHECKER)
    TYPE_CHECKER['version_range'] = parse_version_range
    TYPE_CHECKER['regexpr'] = compile_regexpr
